<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../gUtil/GestoreTabella.php";
    include "../../../classi/Tabella.php";
    
    if(isset($_GET["id"])) {
        $datiOccorrenza = $geecomDb->leggiSingolaRiga("geec_visualizzatoriRisorse",filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - Creazione visualizzatore risorse</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>

    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
            <form action="controller/controllerVisualizzatoreRisorse.php" method="post">
                <div class="row py-4">
                    <input type="text" class="d-none" name="operazione" value="<?php echo((isset($datiOccorrenza) ? "modifica" : "crea")); ?>">
                    <input type="text" class="d-none" name="id" value="<?php echo((isset($datiOccorrenza) ? $datiOccorrenza["id"] : "0")); ?>">
                    
                    <div class="col-lg-8">
                        <div class="form-row justify-content-between mb-3">
                            <div class="col-auto d-flex">
                                <nav aria-label="breadcrumb" class="align-self-center">
                                    <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                        <li class="breadcrumb-item"><a href="../../home.php">Home</a></li>
                                        <li class="breadcrumb-item"><a href="#" data-toggle="modal" data-target="#menu-componenti">Componenti</a></li>
                                        <li class="breadcrumb-item"><a href="index.php">Risorse</a></li>
                                        <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($elemento)? $datiOccorrenza["nome"] : "Nuovo visualizzatore"))?></li>
                                    </ol>
                                </nav>
                            </div>
                            <div class="col-auto text-right">
                                <a class="btn btn-outline-primary" href="index.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                            </div>
                        </div>
                        <div class="card mb-4 box-shadow-lite">
                            <div class="card-header py-3">
                                
                                <div class="row mb-3">
                                    <div class="col-12 d-md-flex align-items-center">
                                        <label for="titolo-articolo" class="mr-3 mb-0">Visualizzatore</label>
                                        <input  type="text" class="form-control form-control-lg" id="titolo-articolo" name="nome" value="<?php echo((isset($datiOccorrenza)? $datiOccorrenza["nome"] : ""))?>" placeholder="Nome">
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label for="descrizione">Descrizione</label>
                                    <textarea class="form-control" id="descrizione" name="descrizione" rows="3"><?php echo((isset($datiOccorrenza)? $datiOccorrenza["descrizione"] : ""))?></textarea>
                                    <small class="text-muted"> Se presente sarà mostrato sotto il nome</small>
                                </div>
                            
                                <div class="row">
                                    <div class="form-group col-lg-3">
                                        <label for="url-seo">Categoria</label>
                                        <select class="form-control" name="categoria">
                                            <option value="0" >Tutte</option>
                                            <?php
                                                $parametri = array("tabella"=>"geec_categorie", "elementiPerPagina"=>100,"parametriRicerca"=>array("tipo"=>"risorsa"),"ajax"=>false);
                                                $ricercaPagine = new Ricerca($geecomDb, $parametri,$impostazioniRicerca,"creaForm.php");
                                                $risultatoQueryPagine = $ricercaPagine->eseguiRicerca(1);
                                                while($categoria = $risultatoQueryPagine->fetch_assoc()) {
                                                    if(isset($datiOccorrenza) && $datiOccorrenza["categoria"]==$categoria["id"]) {
                                                        $selezionato  = "selected";
                                                    }
                                                    else {
                                                        $selezionato  = "";
                                                    }
                                                    echo"<option value=\"{$categoria["id"]}\" $selezionato >{$categoria["nome"]}</option>";
                                                }
                                            ?>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group col-lg-3">
                                        <label for="url-seo">Elementi per riga</label>
                                        <select class="form-control" name="classeElementi">
                                            <?php
                                                $arrayClassiElemento = array("portfolio col-12"=>1,"portfolio col-sm-6"=>2,"portfolio col-sm-6 col-md-4"=>3,"portfolio col-sm-6 col-md-4 col-lg-3"=>4,"portfolio col-sm-6 col-md-4 col-lg-3 col-xl-2"=>6);
                                                foreach($arrayClassiElemento as $classe=>$numeroELementi) {
                                                    if(isset($datiOccorrenza) && $classe==$datiOccorrenza["classeElementi"]) {
                                                        echo"<option value=\"$classe\" SELECTED>{$numeroELementi}</option>";						
                                                    }
                                                    else {
                                                        echo"<option value=\"$classe\">{$numeroELementi}</option>";
                                                    }
                                                }
                                            ?>
                                        </select>
                                    </div>

                                    <div class="form-group col-lg-3">
                                        <label for="select1" class="d-inline mr-3">Filtrabile </label>
                                        <input type="checkbox" name=filtrabile class="js-switch" value="si" <?php
                                              if(isset($datiOccorrenza) && $datiOccorrenza["filtrabile"]=="si") { // se il valore = si aggiunge la parola checked
                                                echo"CHECKED";
                                             }
                                          ?> />
                                        <small class="text-muted d-block">L'utente avrà la possibilità di filtrare le risorse per categoria. <b>Nota: il campo categorie va impostato su tutte</b></small>
                                    </div>
                                
                                    <div class="form-group col-lg-3">
                                        <label for="select1" class="d-inline mr-3">Senza bordi </label>
                                        <input type="checkbox" name=senzaBordi class="js-switch" value="si" <?php
                                              if(isset($datiOccorrenza) && $datiOccorrenza["senzaBordi"]=="si") { // se il valore = si aggiunge la parola checked
                                                echo"CHECKED";
                                             }
                                          ?> />
                                        <small class="text-muted d-block">Non ci saranno spazi tra una risorsa e l'altra</small>
                                    </div>
                                </div>
                                
                                <button type="submit" class="btn btn-primary float-right mt-3"><i class="fas fa-check"></i> Salva</button>
                             </div>
                        </div>
                    </div><!--/Colonna principale -->
                    <!-- Colonna principale -->
            </form>

                    <!--Colonna secondaria -->
                    <div class="col-lg-4 pb-4 align-self-start sticky-top">
                        <div class="btn-group d-flex mb-3" role="group" aria-label="Basic example">
                            <button type="submit" class="btn btn-primary w-100"><i class="fas fa-check mr-2"></i>Salva</button>
                            <?php 
                                if(isset($datiOccorrenza)) {
                            ?>
                                    <button type="button" class="btn btn-warning w-100"  onclick="location.href='controller/controllerVisualizzatoreRisorse.php?id=<?php echo $datiOccorrenza["id"] ?>&operazione=duplica';"><i class="far fa-clone mr-2"></i>Duplica</button>
                            <?php 
                                }
                            ?>
                        </div>
                        <div class="clearfix"></div>
                        
                        <div class="card mb-3 rounded-0 box-shadow-lite">
                            <div class="card-header">
                                <div class="card-title mb-0">
                                    Risorse associate
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive p-1">
                                    <?php
                                        $colonne     = array("ID","Nome","");
                                        $tabella     = new Tabella("tabella", "table table-striped table-hover",$colonne);
                                        if(isset($datiOccorrenza)) {
                                            if($datiOccorrenza["categoria"]==0) {
                                                $parametriRicerca = ["categoria"=>">0"];
                                            }
                                            else {
                                                $parametriRicerca = ["categoria"=>$datiOccorrenza["categoria"]];
                                            }
                                            $parametri = array("tabella"=>"geecB_risorse", "elementiPerPagina"=>100,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);

                                            $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"creaVisualizzatoreRisorse.php"); 
                                            $ricerca->setParametriDaEscludere(array("nome"=>""));
                                            $risRisorseAssociate = $ricerca->eseguiRicerca(1);
                                            while($risorsa = $risRisorseAssociate->fetch_assoc()) {
                                                $tabella->aggiungiNuovaRiga(array("id"=>$risorsa["id"],"nome"=>"<a href=\"../../creaFileScaricabile.php?id={$risorsa["id"]}\"><b>{$risorsa["nome"]}</b></a>"), array());
                                            }
                                        }
                                        $tabella->stampa();
                                    ?>
                                </div>
                            </div>
                        </div>         
                    </div><!--/Colonna secondaria -->
                </form>

            </div>
        </div>
    </main>

    <?php 
        include "../../include/footer.php";        
        
        include "../include/modal/cambiaPassword.php";
        
        include "../../include/modal/modalMenuComponenti.php";
            
        include "../include/jsBaseComponenti.php";
    ?>

        <script>
            function aggiornaCampiEtichette() {
                var etichetta = document.getElementById("etichettaElementoDaModificare").value;
                document.getElementById("nomeElementoDaModificare").value        = etichetta;
                document.getElementById("placeholderElementoDaModificare").value = etichetta;
            }
        
            function modificaElemento(id,etichetta,nome,valore,placeholder,tipo) {
                $('#idElementoDaModificare').val(id);
                $('#etichettaElementoDaModificare').val(etichetta);
                $('#nomeElementoDaModificare').val(nome);
                $('#valoreElementoDaModificare').val(valore);
                $('#placeholderElementoDaModificare').val(placeholder);
                $('#tipoElementoDaModificare').val(tipo);
                $('#modifica-elemento').modal('show');
            }
            
            function eliminaElemento(id,nomeElemento,tipoElemento) {
                $('#elementoDaEliminare').val(id);
                $('#nomeElementoDaEliminare').text(nomeElemento);
                document.getElementById("tipoElementoDaEliminare").innerHTML = tipoElemento;
                $('#modalEliminaElemento').modal('show');
            }
            
            function eseguiEliminazioneElemento() {
                var id = $('#elementoDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"controller/controllerForm.php",
                    data:{
                        operazione:"eliminaElemento",
                        id:<?php echo $datiOccorrenza["id"] ?>,
                        idElemento:id
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("elementoForm"+id).className = "d-none";
                            $('#modalEliminaElemento').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function spostaElementoInput(id) {
                var posizione = $('#nuovaPosizioneElemento'+id).val();
                spostaElemento(id,posizione);
            }
            
            function spostaElemento(id,posizione) {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerForm.php",
                    data:{
                        operazione:"spostaElemento",
                        id:<?php echo $datiOccorrenza["id"] ?>,
                        idElemento:id,
                        posizione:posizione
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("elementoForm"+id).className = "d-none";
                            location.href = "creaForm.php?id=<?php echo $datiOccorrenza["id"] ?>&status=275";
                        }
                        else {
                            alert(result);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function creaElemento() {
                var tipo = $('#tipoElementoDaAggiungere').val();
                $.ajax({
                    type:"POST",
                    url:"controller/controllerForm.php",
                    data:{
                        operazione:"creaElemento",
                        id:<?php echo $datiOccorrenza["id"] ?>,
                        tipo:tipo
                    },
                    success:function(result) {
                        if(result=="ok") {
                            location.href = "creaForm.php?id=<?php echo $datiOccorrenza["id"] ?>&status=200";
                        }
                        else {
                            alert("Si è verificato un errore, contatta l'amministratore del sito")
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function cambiaIdElemento(idComponente) {
                var idElemento = $("#idElementoComponente"+idComponente).val();
                $.ajax({
                    type:"GET",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"cambiaIdElemento",
                        id:idComponente,
                        idElemento:idElemento
                    },
                    success:function(result) {
                        if(result=="ok") {
                            $('#modalComponenteAggiornato').modal('show');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
  </body>
</html>